$listener = New-Object System.Net.HttpListener
$listener.Prefixes.Add('http://localhost:8000/')
$listener.Start()
Write-Host ("Serving http://localhost:8000/ from " + (Get-Location))

while ($true) {
    $context = $listener.GetContext()
    $request = $context.Request
    $response = $context.Response

    $localPath = $request.Url.LocalPath.TrimStart('/')
    if ([string]::IsNullOrWhiteSpace($localPath)) { $localPath = 'popup.html' }

    $fullPath = Join-Path (Get-Location) $localPath

    if (-not (Test-Path $fullPath)) {
        $response.StatusCode = 404
        $bytes = [System.Text.Encoding]::UTF8.GetBytes('404 Not Found')
        $response.OutputStream.Write($bytes,0,$bytes.Length)
        $response.Close()
        continue
    }

    $bytes = [System.IO.File]::ReadAllBytes($fullPath)
    $response.ContentLength64 = $bytes.Length
    $response.OutputStream.Write($bytes,0,$bytes.Length)
    $response.Close()
}